-- Gilchrist


set sql_safe_updates=0;

-- ADD_USER   
-- FORGET_PASSWORD
-- PASSWORD_CHANGE_POLICY   
-- UNLOCK_USER  
-- RESOURCE_BOOKING
-- ADD_ORG_STRUCTURE
-- SERVICE_REQUEST_TERMINATION
-- USER_ACADMEY_LOCATION_ASSOCIATION
-- USER_ROLES_ASSOCIATION
-- MANAGE_FACILITY_EQUIPMENT --2
-- MSG_CREATE_CAMPAIGN
SET @addUser=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_USER_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T2.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.`mobileCountryCode` AS MOBILE_CODE,
    T3.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
    ml.code as LANGUAGE_KEY,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    `staffs` T1
        INNER JOIN
    `users` T2 ON T2.`id` = T1.`userId`
        INNER JOIN
    `persons` T3 ON T3.`id` = T1.`personId`
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
		LEFT JOIN
    fire_base_persons_info f ON f.userId = T1.userId
        LEFT JOIN
	multi_language ml on ml.id=T3.correspondence_language
WHERE
    T2.id IN (namedParams) group by T1.userId" WHERE `dataProviderId`=@addUser;  
    
    
    
-- SERVICE_REQUEST_STATUS_CHANGED
-- SERVICE_REQUEST_COMPLAINT        
SET @srRequestStatus=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_REQUESTER_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T2.id AS ID,
    T5.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY,
    CASE
        WHEN T4.personId IS NULL THEN T1.personId
        ELSE T4.personID
    END
FROM
    persons T3
        LEFT JOIN
    students T4 ON T3.id = T4.personId
        LEFT JOIN
    staffs T1 ON T3.id = T1.personId
        LEFT JOIN
    `salutations` T5 ON T5.`id` = T3.`salutationId`
        LEFT JOIN
    users T2 ON (T4.userId = T2.id OR T1.userId = T2.id)
        LEFT JOIN
	multi_language ml on ml.id=T3.correspondence_language
WHERE
    (T4.userId = namedParams
        OR T1.userId = namedParams)" WHERE `dataProviderId`=@srRequestStatus;     
  

-- ADD_ROLE      
-- UNLOCK_USER  
-- USER_ACADMEY_LOCATION_ASSOCIATION
-- USER_ROLES_ASSOCIATION
-- USER_ROLE_PRIVILEGE_OVERRIDE
SET @addRole=(SELECT id FROM dtprovider WHERE `dataProviderName`='SYSADMIN_DL');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T2.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY
FROM
    `staffs` T1
        INNER JOIN
    `users` T2 ON T2.`id` = T1.`userId`
        INNER JOIN
    `persons` T3 ON T3.`id` = T1.`personId`
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
        LEFT JOIN
	multi_language ml on ml.id=T3.correspondence_language
WHERE
    T2.id IN (namedParams)" WHERE `dataProviderId`=@addRole;
    
-- ADD_ORG_STRUCTURE    
-- CALENDAR_ADD    
-- SA_SAU_MAU_MAPPING --1
-- SA_SAU_MAU_MAPPING --2
SET @addOrg=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_OWNER_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T2.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY
FROM
    `staffs` T1
        INNER JOIN
    `users` T2 ON T2.`id` = T1.`userId`
        INNER JOIN
    `persons` T3 ON T3.`id` = T1.`personId`
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
        LEFT JOIN
	multi_language ml on ml.id=T3.correspondence_language
WHERE
    T2.id IN (namedParams)" WHERE `dataProviderId`=@addOrg;    
  
  
  -- ADD_SCHOLARSHIP_AWARDEE 
  -- SPONSORSHIP_ADD_AWARDEE
  -- SERVICE_REQUEST_COURSE_TRANSFER --1
  -- SERVICE_REQUEST_PROGRAM_TRANSFER --1
  -- SERVICE_REQUEST_SECTION_TRANSFER_STUD --1
  -- STUDENT_LOGIN_CREDENTIAL
  -- STUDENT_VALIDITY_EXPIRED
SET @addScholarship=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_STUDENT_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T3.`firstName` AS FIRST_NAME,
    T3.`middleName` AS MIDDLE_NAME,
    T3.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    admission T1
        INNER JOIN
    students T2 ON T2.userId = T1.studentId
        INNER JOIN
    `persons` T3 ON T3.id = T2.personId
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T2.userId
        LEFT JOIN
	multi_language ml on ml.id=T3.correspondence_language
WHERE
    T1.id IN (namedParams) group by T1.id" WHERE `dataProviderId`=@addScholarship;  
  
-- ADD_SCHOLARSHIP_AWARDEE 
-- SPONSORSHIP_ADD_AWARDEE
-- SERVICE_REQUEST_COURSE_TRANSFER --2
-- SERVICE_REQUEST_PROGRAM_TRANSFER --2
-- SERVICE_REQUEST_SECTION_TRANSFER_STUD --2
SET @addScholarship2=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_PARENT_GUARDIAN_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T3.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T3.`firstName` AS FIRST_NAME,
    T3.`middleName` AS MIDDLE_NAME,
    T3.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY
FROM
    `persons` T3
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
        LEFT JOIN
	multi_language ml on ml.id=T3.correspondence_language
WHERE
    T3.id IN (namedParams)" WHERE `dataProviderId`=@addScholarship2; 
    
-- ADD_SCHOLARSHIP_AWARDEE 
-- POST_SELECTION_TRACKING --3
-- RCPNT_TYPE_RESOURCE_COORDINATOR_DTP
-- SERVICE_REQUEST_COURSE_TRANSFER --3
-- SERVICE_REQUEST_PROGRAM_TRANSFER --3
-- SERVICE_REQUEST_SECTION_TRANSFER_STUD --3
-- SERVICE_REQUEST_SECTION_TRANSFER_FAC--1
SET @addScholarship3=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_RESOURCE_COORDINATOR_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T2.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY
FROM
    `staffs` T1
        INNER JOIN
    `users` T2 ON T2.`id` = T1.`userId`
        INNER JOIN
    `persons` T3 ON T3.`id` = T1.`personId`
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
        LEFT JOIN
	multi_language ml on ml.id=T3.correspondence_language
WHERE
    T2.id IN (namedParams)" WHERE `dataProviderId`=@addScholarship3;   
    

-- SPONSORSHIP_ADD_AWARDEE 
SET @addScholarshipAwardee=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_SPONSOR_CONTACT_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T2.id AS ID,
    T2.contactName AS CONTACT_NAME,
    T3.`primaryeEmailId` AS EMAIL_ID,
    T3.`cellNo` AS MOBILE_NO,
    T3.`cellCountryCode` AS MOBILE_CODE
FROM
    `sponsors` T1
        LEFT JOIN
    `sponsor_contacts` T2 ON T2.sponsorId = T1.id
        LEFT JOIN
    address T3 ON T2.addressId = T3.id
WHERE
    T2.id IN (namedParams)" WHERE `dataProviderId`=@addScholarshipAwardee;     
        
  
  -- POST_SELECTION_TRACKING --1
  -- RCPNT_TYPE_APPLICANT_DTP
  -- SEND_OFFER_LETTER
SET @postSelectionTracking=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_APPLICANT_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT
   T2.id AS ID,
   T3.`salutationName` AS SALUTATION_NAME,
   T2.`firstName` AS FIRST_NAME,
   T2.`middleName` AS MIDDLE_NAME,
   T2.`lastName` AS LAST_NAME,
   T2.`emailId` AS EMAIL_ID,
   T2.`mobileNumber` AS MOBILE_NO,
   T2.`mobileCountryCode` AS MOBILE_CODE,
   ml.code as LANGUAGE_KEY
FROM
   `application` T1 
   INNER JOIN
      `applicant_person` T2 
      ON T2.id = T1.applicantPersonId 
   LEFT JOIN
      `salutations` T3 
      ON T3.`id` = T2.`salutationId` 
   LEFT JOIN
       multi_language ml on ml.id=T2.correspondence_language
WHERE
   T2.id IN 
   (
      namedParams
   )" WHERE `dataProviderId`=@postSelectionTracking; 
   
   
  -- POST_SELECTION_TRACKING --2
  -- RCPNT_TYPE_APPLICANT_PARENT_DTP
SET @postSelectionTracking2=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_APPLICANT_PARENT_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T3.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T3.`firstName` AS FIRST_NAME,
    T3.`middleName` AS MIDDLE_NAME,
    T3.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    ml.code as LANGUAGE_KEY
FROM
    `application` T1
        INNER JOIN
    `applicant_person_relationships` T2 ON T2.applicantPersonId = T1.applicantPersonId
        INNER JOIN
    `applicant_person` T3 ON T2.relatedApplicantPersonId = T3.id
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
        LEFT JOIN
	multi_language ml on ml.id=T3.correspondence_language
WHERE
    T3.id IN (namedParams)
GROUP BY T3.id" WHERE `dataProviderId`=@postSelectionTracking2;    


 -- MANAGE_FACILITY_EQUIPMENT --1
  -- MANAGE_FAC_EQUIPMENT_CONCERNED_PERSON
SET @manageFaclty=(SELECT id FROM dtprovider WHERE `dataProviderName`='MANAGE_FAC_EQUIPMENT_CONCERNED_PERSON');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T2.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    staffs T1
        INNER JOIN
    persons T2 ON T2.id = T1.personId
        LEFT JOIN
    salutations T3 ON T3.`id` = T2.salutationId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T1.userId
        LEFT JOIN
	multi_language ml on ml.id=T2.correspondence_language
    
WHERE
    T1.userId IN (namedParams) group by T1.userId" WHERE `dataProviderId`=@manageFaclty;    
  
  -- SERVICE_REQUEST_SECTION_TRANSFER_FAC --2 
SET @srSectionTransfer=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_FACULTY_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T2.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    staffs T1
        INNER JOIN
    persons T2 ON T2.id = T1.personId
        LEFT JOIN
    salutations T3 ON T3.`id` = T2.salutationId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T1.userId
        LEFT JOIN
	multi_language ml on ml.id=T2.correspondence_language
WHERE
    T1.userId IN (namedParams) group by T1.userId" WHERE `dataProviderId`=@srSectionTransfer;  
 
 
   -- MSG_BIRTHDAY_GREETING 
   
SET @msgBirthday=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_BIRTHDAY_GREETING_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="select ID,BIRTH_DATE,SALUTATION_NAME,FIRST_NAME,MIDDLE_NAME,LAST_NAME,EMAIL_ID,MOBILE_NO,MOBILE_CODE,group_concat(DEVICE_ID) AS DEVICE_ID ,LANGUAGE_KEY from
(
	select 
		s.userId as ID,
        p.birthDate as BIRTH_DATE,
        sal.salutationName as SALUTATION_NAME,
        p.firstName as FIRST_NAME,
        p.middleName as MIDDLE_NAME,
        p.lastName as LAST_NAME,
        p.emailId as EMAIL_ID,
        p.mobileNumber as MOBILE_NO,
        p.mobileCountryCode as MOBILE_CODE,
        f.deviceTokenId AS DEVICE_ID,
		ml.code as LANGUAGE_KEY
	from 
		students s
		inner join users u on u.id = s.userId
		inner join persons p on p.id = s.personId
		left join salutations sal on sal.id = p.salutationId
        LEFT JOIN fire_base_persons_info f ON f.userId = s.userId
		left join multi_language ml on p.correspondence_language=ml.id
	UNION
	select 
		s.userId as ID,
        p.birthDate as BIRTH_DATE,
        sal.salutationName as SALUTATION_NAME,
        p.firstName as FIRST_NAME,
        p.middleName as MIDDLE_NAME,
        p.lastName as MIDDLE_NAME,
        p.emailId as EMAIL_ID,
        p.mobileNumber as MOBILE_NO,
        p.mobileCountryCode as MOBILE_CODE,
        f.deviceTokenId AS DEVICE_ID,
		ml.code as LANGUAGE_KEY
	from 
		staffs s
		inner join users u on u.id = s.userId
		inner join persons p on p.id = s.personId
		left join salutations sal on sal.id = p.salutationId
		LEFT JOIN fire_base_persons_info f ON f.userId = u.id
		left join multi_language ml on p.correspondence_language=ml.id
) as PSEUDO
 where date_format(BIRTH_DATE,'%m-%d') = date_format(now(),'%m-%d')" WHERE `dataProviderId`=@msgBirthday;
 
 
    -- LIME_SURVEY_FACULTIES 
   
SET @limeSurveyFac=(SELECT id FROM dtprovider WHERE `dataProviderName`='LIME_SURVEY_FAC_RECIPIENTS');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T3.`firstName` AS FIRST_NAME,
    T3.`middleName` AS MIDDLE_NAME,
    T3.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T1.`surveyUrl` AS SURVEY_URL,
    T3.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY
FROM
    survey_participant_info T1
        LEFT OUTER JOIN
    staffs T2 ON T1.userId = T2.userId
        LEFT OUTER JOIN
    persons T3 ON T2.personId = T3.id
        LEFT JOIN
    salutations T4 ON T4.id = T3.salutationId
        LEFT JOIN
	multi_language ml on ml.id=T3.correspondence_language
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@limeSurveyFac;
    
    
    -- LIME_SURVEY_STUDENTS 
   
SET @limeSurveySud=(SELECT id FROM dtprovider WHERE `dataProviderName`='LIME_SURVEY_STU_RECIPIENTS');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T3.`firstName` AS FIRST_NAME,
    T3.`middleName` AS MIDDLE_NAME,
    T3.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T1.`surveyUrl` AS SURVEY_URL,
    T3.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY
FROM
    survey_participant_info T1
        LEFT OUTER JOIN
    students T2 ON T1.studentId = T2.userId
        LEFT OUTER JOIN
    persons T3 ON T2.personId = T3.id
        LEFT JOIN
    salutations T4 ON T4.id = T3.salutationId
        LEFT JOIN
	multi_language ml on ml.id=T3.correspondence_language
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@limeSurveySud;  
    
   -- LIME_SURVEY_APPLICANT    
    
SET @limeSurveyApp=(SELECT id FROM dtprovider WHERE `dataProviderName`='LIME_SURVEY_APP_RECIPIENTS');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T3.`firstName` AS FIRST_NAME,
    T3.`middleName` AS MIDDLE_NAME,
    T3.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T1.`surveyUrl` AS SURVEY_URL,
    T3.`mobileCountryCode` AS MOBILE_CODE,
	ml.code as LANGUAGE_KEY
FROM
    survey_participant_info T1
        LEFT OUTER JOIN
    application T2 ON T1.applicantId = T2.id
        LEFT OUTER JOIN
    applicant_person T3 ON T2.applicantPersonId = T3.id
        LEFT JOIN
    salutations T4 ON T4.id = T3.salutationId
         LEFT JOIN
	multi_language ml on ml.id=T3.correspondence_language
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@limeSurveyApp;    
        
  -- MSG_EXTERNAL_USER_ID_PASSWORD   
   
SET @msgExternalUser=(SELECT id FROM dtprovider WHERE `dataProviderName`='ADD_EXTERNAL_USER_RECIPIENT_INFO');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T3.`firstName` AS FIRST_NAME,
    T3.`middleName` AS MIDDLE_NAME,
    T3.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T1.`surveyUrl` AS SURVEY_URL,
    T3.`mobileCountryCode` AS MOBILE_CODE,
	ml.code as LANGUAGE_KEY
FROM
    survey_participant_info T1
        LEFT OUTER JOIN
    application T2 ON T1.applicantId = T2.id
        LEFT OUTER JOIN
    applicant_person T3 ON T2.applicantPersonId = T3.id
        LEFT JOIN
    salutations T4 ON T4.id = T3.salutationId
         LEFT JOIN
	multi_language ml on ml.id=T3.correspondence_language
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@msgExternalUser;  
    
 -- MSG_EXTERNAL_USER_FORGOT_PASSWORD  
   
SET @msgExternalUser2=(SELECT id FROM dtprovider WHERE `dataProviderName`='EXTERNAL_USER_FORGOT_PASSWORD_RECEPIENT_INFO');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T4.`firstName` AS FIRST_NAME,
    T4.`lastName` AS LAST_NAME,
    T4.`emailId` AS EMAIL_ID,
    T4.`mobileNumber` AS MOBILE_NO,
    T4.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
    T4.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY
FROM
    external_users T1
        LEFT JOIN
    external_user_association T2 ON T2.externalUserId = T1.id
        LEFT JOIN
    application T3 ON T3.id = T2.applicationId
        LEFT JOIN
    applicant_person T4 ON T4.id = T3.applicantPersonId
		LEFT JOIN
	multi_language ml on ml.id=T4.correspondence_language
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@msgExternalUser2;       
  
 -- Academy Location Expiry  
   
SET @alExpiry=(SELECT id FROM dtprovider WHERE `dataProviderName`='Academy_Location_Expiry_Rcpnt');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.`id` AS ID,
    T4.`emailId` AS EMAIL_ID,
    T4.`firstName` AS FIRST_NAME,
    T4.`lastName` AS LAST_NAME,
    T4.`mobileNumber` AS MOBILE_NO,
    DATEDIFF(DATE_FORMAT(T1.tillDate, '%Y-%m-%d'),
            DATE_FORMAT(NOW(), '%Y-%m-%d')) AS DAYS_TO_EXPIRE,
    T1.tillDate AS EXPIRY_DATE,
    T5.locationName AS LOCATION_NAME,
    T5.academyName AS ACADEMY_NAME,
    T5.locationCode AS LOCATION_CODE,
    T4.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY
FROM
    academy_location_purpose T1
        LEFT OUTER JOIN
    users T2 ON T1.ownerId = T2.id
        LEFT OUTER JOIN
    staffs T3 ON T3.userId = T2.id
        LEFT OUTER JOIN
    persons T4 ON T3.personId = T4.id
        LEFT OUTER JOIN
    academy_location T5 ON T1.academyLocationId = T5.id
		LEFT JOIN
	multi_language ml on ml.id=T4.correspondence_language
WHERE
    T1.id IN (namedParams)
        AND T1.purposeCode = 'COURSE_EXECUTION'" WHERE `dataProviderId`=@alExpiry;   
  
  
   -- ACADEMY_LOCATION_PURPOSE_CREATION  
   
SET @alPurpose=(SELECT id FROM dtprovider WHERE `dataProviderName`='ACADEMY_LOCATION_PURPOSE_OWNER');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.`id` AS ID,
    T4.`emailId` AS EMAIL_ID,
    T4.`firstName` AS FIRST_NAME,
    T4.`lastName` AS LAST_NAME,
    T4.`mobileNumber` AS MOBILE_NO,
    DATEDIFF(DATE_FORMAT(T1.tillDate, '%Y-%m-%d'),
            DATE_FORMAT(NOW(), '%Y-%m-%d')) AS DAYS_TO_EXPIRE,
    T1.tillDate AS EXPIRY_DATE,
    T5.locationName AS LOCATION_NAME,
    T5.academyName AS ACADEMY_NAME,
    T5.locationCode AS LOCATION_CODE,
    T4.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY
FROM
    academy_location_purpose T1
        LEFT OUTER JOIN
    users T2 ON T1.ownerId = T2.id
        LEFT OUTER JOIN
    staffs T3 ON T3.userId = T2.id
        LEFT OUTER JOIN
    persons T4 ON T3.personId = T4.id
        LEFT OUTER JOIN
    academy_location T5 ON T1.academyLocationId = T5.id
        LEFT JOIN
	multi_language ml on ml.id=T4.correspondence_language
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@alPurpose; 
    
   
   -- PARENT_LOGIN_CREATION  
   -- PARENT_FORGET_PASSWORD
SET @parentLoginCreation=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_PARENT_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T2.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
    T3.mobileCountryCode AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY
FROM
    `parents` T1
        INNER JOIN
    `users` T2 ON T2.`id` = T1.`userId`
        INNER JOIN
    `persons` T3 ON T3.`id` = T1.`personId`
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
        LEFT JOIN
	multi_language ml on ml.id=T3.correspondence_language
WHERE
    T2.id IN (namedParams)" WHERE `dataProviderId`=@parentLoginCreation;        

 
   -- STUDENT_FORGET_PASSWORD
   
SET @studentForget=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_STUDENT_FP_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T2.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY,
	 T3.`alternateEmailId` AS ALTERNATE_EMAIL_ID
FROM
    `students` T1
        INNER JOIN
    `users` T2 ON T2.`id` = T1.`userId`
        INNER JOIN
    `persons` T3 ON T3.`id` = T1.`personId`
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
		LEFT JOIN
	multi_language ml on ml.id=T3.correspondence_language
WHERE
    T2.id IN (namedParams)" WHERE `dataProviderId`=@studentForget;   
    

   -- UPDATE_USER_CODE
   
SET @updateUser=(SELECT id FROM dtprovider WHERE `dataProviderName`='USER_UPDATE_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
	T2.`mobileCountryCode` AS MOBILE_CODE,
	ml.code as LANGUAGE_KEY
FROM
    `users` T1 
	INNER JOIN
	`staffs` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
    LEFT JOIN
	multi_language ml on ml.id=T2.correspondence_language
    
WHERE
    T1.id IN (namedParams)

UNION
SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
	T2.`mobileCountryCode` AS MOBILE_CODE,
	ml.code as LANGUAGE_KEY
FROM
    `users` T1 
	INNER JOIN
	`students` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
    LEFT JOIN
	multi_language ml on ml.id=T2.correspondence_language
WHERE
    T1.id IN (namedParams)

UNION
SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
	T2.`mobileCountryCode` AS MOBILE_CODE,
	ml.code as LANGUAGE_KEY
FROM
    `users` T1 
	INNER JOIN
	`parents` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
	LEFT JOIN
	multi_language ml on ml.id=T2.correspondence_language
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@updateUser;
 
 
    -- RESET_PASSWORD
   
SET @resetPassword=(SELECT id FROM dtprovider WHERE `dataProviderName`='RESET_PASSWORD_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    T2.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
    ml.code as LANGUAGE_KEY,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    `users` T1
        INNER JOIN
    `staffs` T5 ON T5.`userId` = T1.`id`
        LEFT JOIN
    `persons` T2 ON T2.`id` = T5.`personId`
        LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
        LEFT JOIN
    `fire_base_persons_info` f ON f.userId = T1.id
        LEFT JOIN
	multi_language ml on ml.id=T2.correspondence_language
WHERE
    T5.userId IN (namedParams)
GROUP BY T1.id" WHERE `dataProviderId`=@resetPassword;   
            
     -- APPLICANT_RESET_PASSWORD
   
SET @resetPasswordApp=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_RESET_PASSWORD_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T5.`salutationName` AS SALUTATION_NAME,
    T4.`firstName` AS FIRST_NAME,
    T4.`middleName` AS MIDDLE_NAME,
    T4.`lastName` AS LAST_NAME,
    T4.`emailId` AS EMAIL_ID,
    T4.`mobileNumber` AS MOBILE_NO,
    T4.`mobileCountryCode` AS MOBILE_CODE,
    T4.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
    ml.code as LANGUAGE_KEY
FROM
    `external_users` T1 
        INNER JOIN
	`external_user_association` T2 ON T2.`externalUserId` =T1.`id`
		LEFT JOIN
    `application` T3 ON T3.`id` = T2.`applicationId`
		LEFT JOIN
    `applicant_person` T4 ON T4.`id` = T3.`applicantPersonId`
        LEFT JOIN
    `salutations` T5 ON T5.`id` = T4.`salutationId`
        LEFT JOIN
	multi_language ml on ml.id=T4.correspondence_language
WHERE
    T1.id IN(namedParams)" WHERE `dataProviderId`=@resetPasswordApp;  
    
       -- PARENT_RESET_PASSWORD
   
SET @resetPasswordPrnt=(SELECT id FROM dtprovider WHERE `dataProviderName`='PARENT_RESET_PASSWORD_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
	 T2.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
     ml.code as LANGUAGE_KEY
FROM
    `users` T1 
    LEFT JOIN
	`parents` T4 on T4.`userId`=T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`	
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
    LEFT JOIN
	multi_language ml on ml.id=T2.correspondence_language
WHERE
    T4.userId IN (namedParams)" WHERE `dataProviderId`=@resetPasswordPrnt;   
    
      -- STUDENT_RESET_PASSWORD
   
SET @resetPasswordStdnt=(SELECT id FROM dtprovider WHERE `dataProviderName`='STUDENT_RESET_PASSWORD_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    T2.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
	ml.code as LANGUAGE_KEY,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    `users` T1
        INNER JOIN
    `students` T4 ON T4.`userId` = T1.`id`
        LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
        LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
        LEFT JOIN
    `fire_base_persons_info` f ON f.userId = T1.id
        LEFT JOIN
	multi_language ml on ml.id=T2.correspondence_language
WHERE
    T4.userId IN (namedParams)
GROUP BY T1.id" WHERE `dataProviderId`=@resetPasswordStdnt;        


      -- ASSIGN_MEETING_MINUTE
   
SET @assignMeetingMin=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_MEETING_MEMBER_DTP');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T5.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
	T2.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY
FROM
    `users` T1 
	INNER JOIN
	`staffs` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
    LEFT JOIN 
	`event_meeting_minutes_task` T5 on T1.id=T5.ownerId
    LEFT JOIN
	multi_language ml on ml.id=T2.correspondence_language
    
WHERE
    T5.id IN (namedParams)
UNION
SELECT 
    T5.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
	T2.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY
FROM
    `users` T1 
	INNER JOIN
	`students` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
     LEFT JOIN 
	`event_meeting_minutes_task` T5 on T1.id=T5.ownerId
    LEFT JOIN
	multi_language ml on ml.id=T2.correspondence_language
WHERE
    T5.id IN (namedParams)

UNION
SELECT 
    T5.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
	T2.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY
FROM
    `users` T1 
	INNER JOIN
	`parents` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
     LEFT JOIN 
	`event_meeting_minutes_task` T5 on T1.id=T5.ownerId
    LEFT JOIN
	multi_language ml on ml.id=T2.correspondence_language
WHERE
    T5.id IN (namedParams)" WHERE `dataProviderId`=@assignMeetingMin;  
    

      -- MSG_COMMITTEE_TASK
   
SET @msgCommitteeTask=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_COMMITTEE_TASK_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T5.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T5.status AS STATUS,
    T5.type AS MINUTE_TYPE,
    T5.dueDate AS DUE_DATE,
    T5.assignDate AS ASSIGN_DATE,
    T5.completionDate AS COMPLETION_DATE,
    T5.noOfDaysOverdue AS NO_OF_DAYS_OVERDUE,
	T2.`mobileCountryCode` AS MOBILE_CODE,
	ml.code as LANGUAGE_KEY
FROM
    event_meeting_minutes_task T5 
    INNER JOIN
    `users` T1 ON  T1.id = T5.ownerId
	INNER JOIN
	`staffs` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
    LEFT JOIN
	multi_language ml on ml.id=T2.correspondence_language
WHERE
    T5.id IN (namedParams)

UNION
SELECT 
    T5.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T5.status AS STATUS,
    T5.type AS MINUTE_TYPE,
    T5.dueDate AS DUE_DATE,
    T5.assignDate AS ASSIGN_DATE,
    T5.completionDate AS COMPLETION_DATE,
    T5.noOfDaysOverdue AS NO_OF_DAYS_OVERDUE,
	T2.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY
FROM
    event_meeting_minutes_task T5 
    INNER JOIN
    `users` T1 ON  T1.id = T5.ownerId
	INNER JOIN
	`students` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
    LEFT JOIN
	multi_language ml on ml.id=T2.correspondence_language
WHERE
    T5.id IN (namedParams)

UNION
SELECT 
    T5.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T5.status AS STATUS,
    T5.type AS MINUTE_TYPE,
    T5.dueDate AS DUE_DATE,
    T5.assignDate AS ASSIGN_DATE,
    T5.completionDate AS COMPLETION_DATE,
    T5.noOfDaysOverdue AS NO_OF_DAYS_OVERDUE,
	T2.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY
FROM
	event_meeting_minutes_task T5 
    INNER JOIN
    `users` T1 ON  T1.id = T5.ownerId
	INNER JOIN
	`parents` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId` 
    LEFT JOIN
	multi_language ml on ml.id=T2.correspondence_language
    
WHERE
    T5.id IN (namedParams)" WHERE `dataProviderId`=@msgCommitteeTask;    
    

      -- MSG_COMMITTEE_TASK_OVERDUE
   
SET @msgCommitteeTaskOver=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_COMMITTEE_TASK_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T5.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T5.status AS STATUS,
    T5.type AS MINUTE_TYPE,
    T5.dueDate AS DUE_DATE,
    T5.assignDate AS ASSIGN_DATE,
    T5.completionDate AS COMPLETION_DATE,
    T5.noOfDaysOverdue AS NO_OF_DAYS_OVERDUE,
	T2.`mobileCountryCode` AS MOBILE_CODE,
	ml.code as LANGUAGE_KEY
FROM
    event_meeting_minutes_task T5 
    INNER JOIN
    `users` T1 ON  T1.id = T5.ownerId
	INNER JOIN
	`staffs` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
    LEFT JOIN
	multi_language ml on ml.id=T2.correspondence_language
WHERE
    T5.id IN (namedParams)

UNION
SELECT 
    T5.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T5.status AS STATUS,
    T5.type AS MINUTE_TYPE,
    T5.dueDate AS DUE_DATE,
    T5.assignDate AS ASSIGN_DATE,
    T5.completionDate AS COMPLETION_DATE,
    T5.noOfDaysOverdue AS NO_OF_DAYS_OVERDUE,
	T2.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY
FROM
    event_meeting_minutes_task T5 
    INNER JOIN
    `users` T1 ON  T1.id = T5.ownerId
	INNER JOIN
	`students` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
    LEFT JOIN
	multi_language ml on ml.id=T2.correspondence_language
WHERE
    T5.id IN (namedParams)

UNION
SELECT 
    T5.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T5.status AS STATUS,
    T5.type AS MINUTE_TYPE,
    T5.dueDate AS DUE_DATE,
    T5.assignDate AS ASSIGN_DATE,
    T5.completionDate AS COMPLETION_DATE,
    T5.noOfDaysOverdue AS NO_OF_DAYS_OVERDUE,
	T2.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY
FROM
	event_meeting_minutes_task T5 
    INNER JOIN
    `users` T1 ON  T1.id = T5.ownerId
	INNER JOIN
	`parents` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId` 
    LEFT JOIN
	multi_language ml on ml.id=T2.correspondence_language
    
WHERE
    T5.id IN (namedParams)" WHERE `dataProviderId`=@msgCommitteeTaskOver;  
    
    
      -- RESOURCE_EVENT_ASSIGN
   
SET @resourceEventAssign=(SELECT id FROM dtprovider WHERE `dataProviderName`='Resource Participant Recipient');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
	T2.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    `users` T1 
	INNER JOIN
	`staffs` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
    LEFT JOIN
    `fire_base_persons_info` f ON f.userId = T1.id
        LEFT JOIN
	multi_language ml on ml.id=T2.correspondence_language
WHERE
    T1.id IN (namedParams) group by T1.id

UNION
SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
	T2.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    `users` T1 
	INNER JOIN
	`students` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
    LEFT JOIN
    `fire_base_persons_info` f ON f.userId = T1.id
        LEFT JOIN
	multi_language ml on ml.id=T2.correspondence_language
WHERE
    T1.id IN (namedParams) group by T1.id

UNION
SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
	T2.`mobileCountryCode` AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    `users` T1 
	INNER JOIN
	`parents` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
    LEFT JOIN
    `fire_base_persons_info` f ON f.userId = T1.id
	LEFT JOIN
	multi_language ml on ml.id=T2.correspondence_language
WHERE
    T1.id IN (namedParams) group by T1.id" WHERE `dataProviderId`=@resourceEventAssign;           

    
      -- TASK_EVENT_ASSIGN
   
SET @taskEventAssign=(SELECT id FROM dtprovider WHERE `dataProviderName`='Task Participant Recipient');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
	T2.`mobileCountryCode` AS MOBILE_CODE,
	ml.code as LANGUAGE_KEY
FROM
    `users` T1 
	INNER JOIN
	`staffs` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
    LEFT JOIN
	multi_language ml on ml.id=T2.correspondence_language
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@taskEventAssign;


   
      -- ADD_EXTERNAL_USER_VELOCITY
   
SET @addExternalUserVel=(SELECT id FROM dtprovider WHERE `dataProviderName`='ADD_EXTERNAL_USER_VELOCITY_RECIPIENT_INFO');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T4.`firstName` AS FIRST_NAME,
    T4.`lastName` AS LAST_NAME,
    T4.`printName` AS STUDENT_PRINT_NAME,
    T6.`emailId` AS EMAIL_ID,
    T6.`mobileNumber` AS MOBILE_NO,
    T6.`mobileCountryCode` AS MOBILE_CODE,
    T6.`firstName` AS PARENT_FIRSTNAME,
    T6.`lastName` AS PARENT_LASTNAME,
    T6.`printName` AS PARENT_PRINT_NAME,
    T3.`code` AS APPLICATION_CODE,
    ml.code as LANGUAGE_KEY,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL
FROM
    external_users T1
        LEFT JOIN
    external_user_association T2 ON T2.externalUserId = T1.id
        LEFT JOIN
    application T3 ON T3.id = T2.applicationId
        LEFT JOIN
    applicant_person T4 ON T4.id = T3.applicantPersonId
        LEFT JOIN
    applicant_person_relationships T5 ON T5.applicantPersonId = T4.id
        LEFT JOIN
    applicant_person T6 ON T6.id = T5.relatedApplicantPersonId
        LEFT OUTER JOIN
    application_program T7 ON T7.applicationId = T3.id
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T7.academyLocationId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
     LEFT JOIN
	multi_language ml on ml.id=T4.correspondence_language       
WHERE
    T1.id IN (namedParams)
        AND T5.relationship = 'FATHER'" WHERE `dataProviderId`=@addExternalUserVel;


      -- BULK_DOCUMENT_DOWNLOAD_EVENT
   
SET @downloadEvent=(SELECT id FROM dtprovider WHERE `dataProviderName`='BULK_DOCUMENT_DOWNLOAD_RECIPIENT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T5.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
	-- T6.`ftpURL` AS FTP_URL,
	T5.`filePath` AS FILE_PATH,
     ml.code as LANGUAGE_KEY
FROM
    `users` T1 
	INNER JOIN
	`staffs` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
    LEFT JOIN 
	`bulk_document_download_status` T5 on T1.id=T5.lastUpdatedBy
	-- LEFT JOIN 
	-- `ftp_server_configuration` T6 on T1.id=T5.lastUpdatedBy
    LEFT JOIN
	multi_language ml on ml.id=T2.correspondence_language
WHERE
    T5.id IN (namedParams)" WHERE `dataProviderId`=@downloadEvent;
    
    
      -- ATTENDANCE_MISSED_BY_FACULTY
   
SET @attendenceMissedbyFac=(SELECT id FROM dtprovider WHERE `dataProviderName`='DAILY_ATTENDANCE_MISSED_BY_FACULTY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
	DATE_FORMAT(T1.sessionDate, '%d-%m-%Y') AS SESSION_DATE,
    T2.courseVariantDescription AS COURSE_VARIANT_DESCRIPTION,
    T3.displayName AS ACADEMY_NAME,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
	T5.emailId AS EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
    T6.salutationName AS SALUTATION_NAME,
    DATE_FORMAT(T1.slotFrom, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T1.slotTo, '%h:%i %p') AS SLOT_TO,
    ml.code as LANGUAGE_KEY
FROM
    course_coverage_plan T1
        LEFT JOIN
    course_variants T2 ON T2.id = T1.courseVariantId
        LEFT JOIN
    academy_location T3 ON T3.id = T1.academyLocationId
        LEFT JOIN
    staffs T4 ON T4.userId = T1.facultyId
        LEFT JOIN
    persons T5 ON T5.id = T4.personId
    LEFT join
    salutations T6 ON T6.id = T5.salutationId
    LEFT JOIN
	multi_language ml on ml.id=T5.correspondence_language
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId`=@attendenceMissedbyFac;    


     -- ATTENDANCE_MISSED_BY_TEACHER
   
SET @attendenceMissedbyTeach=(SELECT id FROM dtprovider WHERE `dataProviderName`='DAILY_ATTENDANCE_MISSED_BY_TEACHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    s.id AS ID,
    s.sectionCode AS SECTION_CODE,
    prsn.emailId AS EMAIL_ID,
    prsn.mobileCountryCode AS MOBILE_CODE,
    prsn.mobileNumber AS MOBILE_NO,
    prsn.firstName AS FIRST_NAME,
    prsn.lastName AS LAST_NAME,
    pgrm.programName AS PROGRAM_NAME,
    b.batchName AS BATCH_NAME,
    DATE_FORMAT(DATE(NOW() - INTERVAL 1 DAY), '%d-%m-%Y') AS ATTENDANCE_DATE,
    al.displayName AS ACADEMY_NAME,
    ml.code as LANGUAGE_KEY
FROM
    sections AS s
        JOIN
    prog_batch_period_config AS pbp ON (s.periodId = pbp.id
        AND pbp.isCurrentPeriodOfProgram = 1)
        JOIN
    batches AS b ON (b.id = pbp.programBatchId)
        LEFT JOIN
    programs AS pgrm ON pgrm.id = b.programId
        LEFT JOIN
    academy_location al ON al.id = pgrm.academyLocationId
        LEFT JOIN
    staffs AS st ON st.userId = s.facultyId
        LEFT JOIN
    persons prsn ON prsn.id = st.personId
        JOIN
    calendar_working_weekdays AS cww ON cww.calendarId = b.calendarId
        JOIN
    calendar_weekdays AS cw ON cww.calendarWeekdayId = cw.id
        AND cw.weekDay = DAYNAME(DATE(NOW() - INTERVAL 1 DAY))
        LEFT JOIN
    student_program_attendance AS spa ON s.id = spa.sectionId
        AND s.facultyId = spa.facultyId
        AND spa.dateOfAttendance = DATE(NOW() - INTERVAL 1 DAY)
        AND spa.attendanceType = 'COMPLETE_DAY',
    time_dimension AS td
        LEFT JOIN
	multi_language ml on ml.id=prsn.correspondence_language
WHERE
    spa.id IS NULL AND s.id IN (namedParams)
        AND td.trans_date = DATE(NOW() - INTERVAL 1 DAY)
        AND b.calendarId NOT IN (SELECT 
            calendar_holidays.calendarId
        FROM
            time_dimension
                JOIN
            calendar_holidays ON trans_date BETWEEN fromDate AND toDate
        WHERE
            time_dimension.trans_date = DATE(NOW() - INTERVAL 1 DAY)
        GROUP BY trans_date , calendarId)" WHERE `dataProviderId`=@attendenceMissedbyTeach;    
        
   set sql_safe_updates=1;
